/*****************************************
*Dateiname: HeaderHistory.java
*Autor: Utz Roedig, modifiziert durch Gunter Wei
*letzte Aenderung: 4.5.97
*Inhalt: Panelklasse Historypanel
*****************************************/

import java.awt.*;
import java.lang.Object;
import java.util.Vector;
import History;

/*****************************************
*Klasse: HeaderHistory
*Beschreibung: Legt ein Historypanel an
*****************************************/
class HeaderHistory extends Panel implements Runnable{

  Thread t;                             // der Thread
  TcpStarter outerparent;               // Hauptklasse
  List list1;                           // die Historylist
  Host h1,h2;                           // die beiden zu protokollierenden Hosts
  public Image blitz;
  String ident;
  int counter,dx,dy;
  int size;
  int font = 14;
  int von=0;
  int length=1;
  int oldlength=1;
  HTcpSegment newesth1,newesth2;        // das aktuelle Segment

  History hist;              // die graphische Variante

  //Layout
  Label titel       = new Label("History");
  Panel buttonpanel = new Panel();
  Button clear      = new Button("Clear History Panel");
  Scrollbar s1;

/*****************************************
* Methode:       HeaderHistory
* Beschreibung:  initialisiert das Historypanel
* Parameter:     host1, host2, hauptfenster,
* Rckgabewert : keiner
*****************************************/
public HeaderHistory (Host h1,Host h2,TcpStarter home,int screen){
    this.h1=h1;
    this.h2=h2;
    this.outerparent=home;
    this.size = screen;


    // *****Layout
    this.resize(440,265); // letzte nd.
    setBackground(Color.lightGray);
    setForeground(Color.red);
    setLayout(new BorderLayout());
    titel.setFont(new Font("Courier",Font.BOLD,font));
    titel.setAlignment(Label.CENTER);
    titel.disable();
    s1=new Scrollbar(Scrollbar.VERTICAL,0,1,0,20);
    hist=new History(h1,h2,von,size,home);
    buttonpanel.setLayout(new GridLayout(1,1,5,5));
    buttonpanel.add(clear);
    add("Center",hist);
    add("North",titel);
    add("East",s1);
    add("South",buttonpanel);
    this.repaint();
    // *****Layout

    changeSize( size, ident);
    show();

    // Thread
    this.start();
    t. setPriority(7);

    clickedClearButton();
}
 /*****************************************
* Methode: start
* Beschreibung: zum Starten des Threads
* Parameter:  keine
* Rckgabewert : keiner
*****************************************/
public void start(){
        if (t==null){
            t=new Thread(this);
            t.start();
        }
}
/*****************************************
* Methode: run
* Beschreibung: Run Methode,Periodische berprfung
* Parameter:  keine
* Rckgabewert : keiner
*****************************************/
 public void run(){
    while (true){
    try{t.sleep(100);} catch( InterruptedException e){}
    length = h1.t1.history.size();
    //System.out.println("h1.t1.history.size(): " + length);
    //System.out.println("von: " + von);
    s1. setValues(von,1,0,length+2);
    if (oldlength < length) hist.repaint();
    oldlength = length;
    }
 }
/*****************************************
* Methode: clickedClearButton()
* Beschreibung: History lschen
* Parameter:  keine
* Rckgabewert : keine
*****************************************/
public void clickedClearButton() {
    System. out.println("clickedClearButton() + length: " + length);
    h1. t1.history.removeAllElements();
    h2. t1.history.removeAllElements();
    hist. repaint();
}
/******************************************************************************
* Method: changeSize
* Description: scales the History and paints it
* Parameters: quality factor
* Return Value: none
******************************************************************************/
public void changeSize( int qual , String ident) {
    this .size = qual;
    this .ident = ident;
    if( size == 1 ){
      dx = 440;  //factor 1
      dy = 265;
      font = 14;
    }
    else if( size == 2 ){
      dx = 564;  //factor 1,25
      dy = 334;
      font = 16;
    }
    else if( size == 3 ){
      dx = 720;  //factor 1,6
      dy = 432;
      font = 18;
    }
    else if( size == 4 ){
      dx = 900;  //factor 2
      dy = 540;
      font = 24;
    }
    titel. setFont(new Font("Courier",Font.BOLD,font));
    //System.out.println("headerhist- screen: " + this.size);
    hist. changeSize(size);
    resize( dx, dy );
    repaint();
    validate();
  }


/*****************************************
* Methode: handleEvent
* Beschreibung:
* Parameter:
* Rckgabewert :
*****************************************/
public boolean handleEvent(Event event) {
    if (event.id == Event.ACTION_EVENT && event.target == clear) {
        clickedClearButton();
        return true;
    }
    if (event.target instanceof Scrollbar){
      von = ((Scrollbar)event.target).getValue();
      hist. setData(von);
      return true;
    }
    return super.handleEvent(event);
}

}

